
class CommandError < RuntimeError
	def initialize(command, msg, status)
		@command = command
		@msg = msg
		@status = status
	end
	attr_reader :msg, :status
	def to_s
		return "#{@command} (#{@status}): #{@msg}"
	end
end

def executeOrRaise(*command)
	$log.debug0 "executing: #{command.join(" ")}"
	out = `#{command.join(" ")} 2>&1`
	if $?.exitstatus != 0
		raise CommandError.new(command.join(" "), out, $?.exitstatus)
	else
		return out
	end
end



$log.debug "#{File.basename(__FILE__, ".*")} loaded"
