#ifndef VFIELD_NODE_H__
#define VFIELD_NODE_H__ 1

#include "exception.h"
#include <stdint.h>
#include <cstring>
#include <netinet/in.h>

namespace VFIELD {


// 定義はip46.ccに記述
class addr46_t;
class NodeIdentity {
friend class NodeIdentityHash;
public:
	const static unsigned short raw_size = 19;
public:
	explicit NodeIdentity(const char* net_data)
		{ ::memcpy(m_data, net_data, raw_size); }
		// throw()
	NodeIdentity(const char* numeric_host, const char* port);	// ホストバイトオーダー
		// throw( InvalidAddressException )
	NodeIdentity() {}		// EngineCommander
	~NodeIdentity() throw() {}
public:
	bool isIPv6(void) const;	// throw()
	bool isIPv4(void) const;	// throw()
public:
	inline const struct in6_addr* getIPv6Address(void) const	{ return   (struct in6_addr*)&m_data[1];   }
	inline const struct in_addr   getIPv4Address(void) const	{ return *((struct in_addr* )&m_data[13]); }
	inline uint16_t getPortN(void) const			{ return *((uint16_t*)&m_data[17]);  }
									// ネットワークバイトオーダー
	inline const char* getNetRaw(void) const		{ return m_data; }
public:
	// 出力用
	uint16_t getPortHostByteOrder(void) const;		// throw()	// ホストバイトオーダー
	const char* addressString(char* dst, size_t cnt) const;	// throw()
	std::string addressString(void) const;
private:
	char m_data[raw_size];
	// +-------+-----------------+---------+
	//  flag[1]     address[16]     port[2]		// ネットワークバイトオーダー
	//    [0]     [1]   -    [16]  [17]-[18]
public:
	// std::map用
	inline bool operator< (const NodeIdentity& rhl) const
		{ return m_data < rhl.m_data; }
public:
	// hash_map, VTable::rpcNotifyDownで自分の確認 用
	// IPv4射影アドレスは、ただのIPv4とは別とみなす
	inline bool operator== (const NodeIdentity& rhl) const
		{ return ::memcmp(m_data, rhl.m_data, raw_size) == 0; }
};


struct InvalidAddressException : public SystemCallException {
	InvalidAddressException(int errno_, const std::string& message) :
		SystemCallException(errno_, message) {}
};


}  // namespace VFIELD

#endif /* node.h */
