#ifndef VFIELD_TOOLS_H__
#define VFIELD_TOOLS_H__ 1

#include <netinet/in.h>

namespace VFIELD {

template <typename T>
inline const T& enconst(const T& x) { return x; }

inline uint64_t ntohll(uint64_t n)
{
	union {
		uint64_t ui64;
		struct {
			uint32_t up;
			uint32_t down;
		} ui32;
	} u;
	u.ui64 = n;
	uint64_t up   = ntohl(u.ui32.up);
	uint64_t down = ntohl(u.ui32.down);
	return (up << 32) ^ (down << 0);
}

inline uint64_t htonll(uint64_t h)
{
	union {
		uint64_t ui64;
		struct {
			uint32_t up;
			uint32_t down;
		} ui32;
	} u;
	u.ui32.up   = htonl(h >> 32);
	u.ui32.down = htonl(h >> 0);
	return u.ui64;
}

template<typename InputIterator,
	 typename OutputIterator,
	 typename Predicate>
OutputIterator copy_if(InputIterator begin,
		       InputIterator end,
		       OutputIterator destBegin,
		       Predicate p)
{
	while( begin != end ) {
		if( p(*begin) ) *destBegin++ = *begin;
		++begin;
	}
	return destBegin;
}


}  // namespace VFIELD


#ifndef likely
#if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 96)
#define likely(cond) __builtin_expect(!!(int)(cond), 1)
#define unlikely(cond) __builtin_expect((int)(cond), 0)
#else
#define likely(cond) (cond)
#define unlikely(cond) (cond)
#endif
#endif /* !likely */


#endif /* tools.h */
