#ifndef VFIELD_IP46_H__
#define VFIELD_IP46_H__

#include "node.h"
#include <vector>
#include <string>
#include <cstring>
#include <stdint.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <iostream>

namespace VFIELD {


class addr46_t;


// for receive
int listenTCP46(const char* numeric_port_str);		// ポート番号は数字で構成された文字列
int listenTCP46(uint16_t port);				// ポート番号はホストバイトオーダ
int listenUDP46(const char* numeric_port_str);		// ポート番号は数字で構成された文字列
//int listenUDP46(uint16_t port);				// ポート番号はネットワークバイトオーダ
int accept46(int sock, addr46_t* from) throw();
ssize_t recvfrom46(int sock, void* buf, size_t len, int flags, addr46_t* from) throw();



// for send
int connectTCP46(const addr46_t& to) throw();
int timed_connectTCP46(const addr46_t& to, long sec, long usec) throw();
	// timed_connectTCP46で返ってくるソケットはNonBlockingモード
int socketUDP6(void);
int socketUDP4(void);
int sendto46(int sock, const void* buf, size_t len, int flags, const addr46_t& to) throw();


// misc
// TODO: IPv6に対応していない？
int setTimeout(int sock, long send_sec, long send_usec, long recv_sec, long recv_usec) throw();
void getIfList(std::vector<std::string>& result);
std::string getIfAddr(const std::string& ifname);


// addr46_t
class stripped_addr46_t;
class addr46_t {
public:
	inline addr46_t() {}
	inline addr46_t(const NodeIdentity& node);	// implicit
	explicit addr46_t(const stripped_addr46_t& strip);  // 定義はstream.cc  // ポート番号は不完全
	~addr46_t() {}
public:
	bool isIPv6(void) const { return (((struct sockaddr*)&addr_in.sin)->sa_family == AF_INET6); }
	bool isIPv4(void) const { return (((struct sockaddr*)&addr_in.sin)->sa_family == AF_INET ); }
public:
	const struct sockaddr_in6* getsin6(void) const { return &addr_in.sin6; }
	const struct sockaddr_in*  getsin (void) const { return &addr_in.sin;  }
public:
	// 出力用
	const char* addressString(char* dst, size_t cnt) const;
	std::string addressString(void) const;
public:
	// hash_map用
	// 定義はstream/strea.cc
	bool operator== (const addr46_t& rhl) const throw();
private:
	union {
		struct sockaddr_in6 sin6;
		struct sockaddr_in  sin;
	} addr_in;
friend int accept46(int sock, addr46_t* from) throw();
friend ssize_t recvfrom46(int sock, void* buf, size_t len, int flags, addr46_t* from) throw();
friend std::ostream& operator<< (std::ostream& stream, const addr46_t& rhl);
};




addr46_t::addr46_t(const NodeIdentity& node)
{
	::memset(&addr_in.sin6, 0, sizeof(struct sockaddr_in6));
	if( node.isIPv6() ) {
		addr_in.sin6.sin6_family = AF_INET6;
		addr_in.sin6.sin6_port   = node.getPortN();
		::memcpy(&addr_in.sin6.sin6_addr, node.getIPv6Address(), sizeof(struct sockaddr_in6));
	} else {
		addr_in.sin.sin_family = AF_INET;
		addr_in.sin.sin_port   = node.getPortN();
		addr_in.sin.sin_addr.s_addr = node.getIPv4Address();
	}
}


}  // namespace VFIELD

#endif /* ip46.h */
