#ifndef __USBMAP_H_INCLUDED
#define __USBMAP_H_INCLUDED 1

#include "usbids_types.h"
#include "sdbase.h"
#include <list>
#include <vector>
#include <map>

namespace SimpleDetect {


class USBMap {
public:
	USBMap(const std::string& map_path);
	~USBMap();
public:
	void load(void);
public:
	const std::list<std::string> getModuleName(USBIDTypes::Vendor::id_type vendor_id, USBIDTypes::Device::id_type device_id) const;
private:
	std::string m_map_path;
	typedef DualID<USBIDTypes::Vendor::id_type, USBIDTypes::Device::id_type> vandd_t;
	typedef std::multimap<vandd_t, std::string> map_t;
	map_t m_map;
private:
	USBMap();
};


}  // namespace SimpleDetect

#endif /* usbmap.h */
