#include "usbmap.h"
#include <fstream>
#include <sstream>
#include <functional>
#include <iterator>
#include <stdexcept>

namespace SimpleDetect {


using namespace USBIDTypes;


// コンストラクタ
USBMap::USBMap(const std::string& map_path) :
	m_map_path(map_path)
{}


// デストラクタ
USBMap::~USBMap()
{}


// public:
void USBMap::load(void)
{
	std::ifstream file(m_map_path.c_str());
	if( ! file.is_open() ) {
		std::string msg( std::string("Can't open ") + m_map_path );
		throw std::runtime_error( msg );
	}

	char buf[256];

	unsigned int match_flags;
	Vendor::id_type vendor_id;
	Device::id_type device_id;
	std::string module;
	while( ! file.eof() ) {
		file.getline(buf, sizeof(buf));
		std::istringstream line_stream(buf);

		line_stream >> module >> std::hex >> match_flags >> vendor_id >> device_id;
		if( line_stream.fail() ) continue;
		if( vendor_id == 0 )
		m_map.insert( std::make_pair( vandd_t(vendor_id, device_id), module) );
	}

	file.close();
}


namespace {
template <typename Pair>
class PushSecondToList {
public:
	typedef std::list<typename Pair::second_type> value_type;
public:
	PushSecondToList(value_type& list) :
		m_inserter( std::back_inserter(list) )
	{}
public:
	void operator() (const Pair& pair)
	{
		// 実装
		m_inserter = pair.second;
	}
private:
	std::back_insert_iterator<value_type> m_inserter;
private:
	PushSecondToList();
};
} // noname namespace


const std::list<std::string> USBMap::getModuleName(USBIDTypes::Vendor::id_type vendor_id, USBIDTypes::Device::id_type device_id) const
{
	std::pair<map_t::const_iterator, map_t::const_iterator> found(
			m_map.equal_range( vandd_t(vendor_id, device_id) )
			);
	std::list<std::string> ret;
	std::for_each(	found.first,
			found.second,
			PushSecondToList<map_t::value_type>(ret)
			);
	return ret;
}


}  // namespace SimpleDetect
