#ifndef __UNION_BUFFER_H_INCLUDED
#define __UNION_BUFFER_H_INCLUDED 1

#include <iostream>
#include <utility>
#include <list>
#include <boost/function.hpp>
#include <boost/bind.hpp>

namespace VIVER {


class UnionStreamBuffer : public std::streambuf {
public:
	typedef boost::function<void (const char*)> WriterFunction;
	UnionStreamBuffer();
public:
	typedef std::list<WriterFunction>::iterator WriterID;
	WriterID addWriter(WriterFunction writer_func);
	void removeWriter(WriterID& id);
	int sync();
private:
	static const size_t buffer_size = 1024;
	char m_buffer[buffer_size+2];
	std::list<WriterFunction> m_writers;
	inline void setInitialPointers(void);
};


}  // namespace VIVER

#endif /* union_buffer.h */
