#include "shell.h"
#include "constant.h"
#include <iostream>
#include <sys/types.h>
#include <sys/wait.h>
#include <stdlib.h>
#include <stdio.h>

namespace VIVER {

// コンストラクタ
Shell::Shell()
{}

// デストラクタ
Shell::~Shell()
{}


// public
int Shell::execShell(const std::string& cmdfile_path)
{
	int pid;
	int status_raw;
	int status;
	int ret_waitpid;

	if ( (pid=::fork()) == 0 ) {
		// 子プロセス
		::setenv("VIVER_COMMAND_FILE_PATH", cmdfile_path.c_str(), 1);
		::execl("/bin/sh", "sh", NULL);
		::exit(127);
	} else if ( pid == -1 ) {
		return Component::UserMessage::EXEC_ERROR;
	}

	// 親プロセス
	ret_waitpid = ::waitpid(pid, &status_raw, 0);
	status = WEXITSTATUS(status_raw);

	return status;
}


}  // namespace VIVER
