#ifndef __SDUSB_KNOWN_H_INCLUDED
#define __SDUSB_KNOWN_H_INCLUDED 1

#include "sdbase.h"
#include "sdusb.h"

namespace SimpleDetect {

namespace USBKnown {


void loadBusDrivers(ModuleLoader& loader)
{
	loader("ehci-hcd");
	loader("uhci-hcd");
	loader("ohci-hcd");
}


bool isKnown(	USBIDTypes::BaseClass::id_type baseclass_id,
		USBIDTypes::SubClass::id_type  subclass_id,
		sdUSB::known_class_t* result )
{
	switch( baseclass_id ) {
	case 0x01:	// Audio
		*result = sdUSB::AUDIO;
		return true;
	case 0x02:	// Communications
		switch( subclass_id ) {
		case 0x06:	// Ethernet Networking
		case 0x07:	// ATM Networking
			*result = sdUSB::NETWORK;
			return true;
		}
		break;
	case 0x03:	// Human Interface Devices
		*result = sdUSB::HID;
		return true;
	case 0x08:	// Mass Storage
		*result = sdUSB::STORAGE;
		return true;
	}

	return false;
}


void loadKnownDriversAuto(ModuleLoader& loader, sdUSB::known_class_t known_class)
{
	switch(known_class) {
	case sdUSB::STORAGE:
		loader("usb-storage");
		break;
	case sdUSB::HID:
		loader("usbhid");
		break;
	case sdUSB::NETWORK:
		loader("usbnet");
		break;
	case sdUSB::AUDIO:
		loader("snd-usb-audio");
		break;
	}
}


void loadKnownDriversForce(ModuleLoader& loader, sdUSB::known_class_t known_class)
{
	switch(known_class) {
	case sdUSB::STORAGE:
		break;
	case sdUSB::HID:
		break;
	case sdUSB::NETWORK:
		break;
	case sdUSB::AUDIO:
		break;
	}
}


void loadSpecificDrivers(ModuleLoader& loader, const USBDevice& device)
{
}


}  // namespace USBKnown

}  // namespace SimpleDetect

#endif /* sdusb_known.h */
