#ifndef __SDUSB_H_INCLUDED
#define __SDUSB_H_INCLUDED 1

#include "sdbase.h"
#include <string>
#include <ostream>

namespace SimpleDetect {


class sdUSBIMPL;

class sdUSB {
public:
	sdUSB(const std::string& ids_path, const std::string map_path);
	~sdUSB();
public:
	void initialize(void);
public:
	typedef enum {
		AUTO,
		FORCE,
		NEVER,
	} load_config_t;
	typedef enum {
		SPECIFIC,
		STORAGE,
		HID,
		NETWORK,
		AUDIO,
	} known_class_t;
public:
	void setBaseClassBasedLoadConfig  (const std::string& class_substr, load_config_t config);
	void setSubClassBasedLoadConfig   (const std::string& class_substr, load_config_t config);
	void setKnownClassBasedLoadConfig (known_class_t known_class,       load_config_t config);
	void detect(ModuleLoader& loader);
	void showDetectedDevices(std::ostream& stream) const;
private:
	sdUSBIMPL* m_impl;
private:
	sdUSB();
};


}  // namespace SimpleDetect

#endif /* sdusb.h */
