#include "sdusb.h"
#include "sdusb_impl.h"

namespace SimpleDetect {


// コンストラクタ
sdUSB::sdUSB(const std::string& ids_path, const std::string map_path) :
	m_impl( new sdUSBIMPL(ids_path, map_path) )
{}

// デストラクタ
sdUSB::~sdUSB()
{}


// public:
void sdUSB::initialize(void)
{
	m_impl->initialize();
}

void sdUSB::setBaseClassBasedLoadConfig  (const std::string& class_substr, load_config_t config)
{
	m_impl->setBaseClassBasedLoadConfig(class_substr, config);
}

void sdUSB::setSubClassBasedLoadConfig   (const std::string& class_substr, load_config_t config)
{
	m_impl->setSubClassBasedLoadConfig(class_substr, config);
}

void sdUSB::setKnownClassBasedLoadConfig (known_class_t known_class, load_config_t config)
{
	m_impl->setKnownClassBasedLoadConfig(known_class, config);
}

void sdUSB::detect(ModuleLoader& loader)
{
	m_impl->detect(loader);
}

void sdUSB::showDetectedDevices(std::ostream& stream) const
{
	m_impl->showDetectedDevices(stream);
}


}  // namespace SimpleDetect
