#ifndef __SDPCI_KNOWN_H_INCLUDED
#define __SDPCI_KNOWN_H_INCLUDED 1

#include "sdbase.h"
#include "sdpci.h"

#include <iostream>

namespace SimpleDetect {

namespace PCIKnown {


void loadBusDrivers(ModuleLoader& loader)
{
}

bool isKnown(	PCIIDTypes::BaseClass::id_type baseclass_id,
		PCIIDTypes::SubClass::id_type  subclass_id,
		sdPCI::known_class_t* result )
{
	switch( baseclass_id ) {
	case 0x01:	// Mass storage controller
		switch( subclass_id ) {
		case 0x00:	// SCSI storage controller
		case 0x07:	// Serial Attached SCSI controller
			*result = sdPCI::STORAGE_SCSI;
			return true;
		case 0x01:	// IDE interface
		case 0x05:	// ATA controller
			*result = sdPCI::STORAGE_IDE;
			return true;
		case 0x06:	// SATA controller
		case 0x04:	// RAID bus controller
			*result = sdPCI::STORAGE_SATA;
			return true;
		}
		break;
	case 0x06:	// Bridge
		switch( subclass_id ) {
		case 0x05:	// PCMCIA bridge
		case 0x07:	// CardBus bridge
			*result = sdPCI::BRIDGE_PCCARD;
			return true;
		}
		break;
	case 0x0c:	// Serial bus controller
		switch( subclass_id ) {
		case 0x00:	// FireWire (IEEE 1394)
			*result = sdPCI::BUS_FIREWIRE;
			return true;
		case 0x03:	// USB Controller
			*result = sdPCI::BUS_USB;
			return true;
		}
		break;
	}

	return false;
}


void loadKnownDriversAuto(ModuleLoader& loader, sdPCI::known_class_t known_class)
{
	switch(known_class) {
	case sdPCI::BRIDGE_PCCARD:
		loader("yenta_socket");
		break;
	case sdPCI::BUS_USB:
		break;
	case sdPCI::BUS_FIREWIRE:
		loader("ohci1394");	// ohciホストコントローラドライバ	// 検出可能だがロード

		loader("pcilynx");	// Texas Instruments PCILynx/PCILynx2ホストコントローラドライバ
										// 検出可能だがロード
		loader("sbp2");		// FireWireストレージドライバ
		loader("sd_mod");
		loader("sr_mod");
		break;
	case sdPCI::STORAGE_SCSI:
		loader("sd_mod");
		loader("sr_mod");
		break;
	case sdPCI::STORAGE_IDE:
		loader("ide-disk");
		loader("ide-cd");
		break;
	case sdPCI::STORAGE_SATA:
		loader("libata");	// SATAストレージベースドライバ
		loader("sd_mod");
		loader("sr_mod");
		break;
	case sdPCI::SPECIFIC:
		break;
	}
}


void loadKnownDriversForce(ModuleLoader& loader, sdPCI::known_class_t known_class)
{
	switch(known_class) {
	case sdPCI::BRIDGE_PCCARD:
		break;
	case sdPCI::BUS_USB:
		break;
	case sdPCI::BUS_FIREWIRE:
		break;
	case sdPCI::STORAGE_SCSI:
		break;
	case sdPCI::STORAGE_IDE:
		break;
	case sdPCI::STORAGE_SATA:
		loader("ahci");		// Intel AHCI SATA Controller
		break;
	case sdPCI::SPECIFIC:
		break;
	}
}


void loadSpecificDrivers(ModuleLoader& loader, const PCIDevice& device)
{
}


}  // namespace PCIKnown

}  // namespace SimpleDetect

#endif /* sdpci_known.h */
