#ifndef __SDPCI_H_INCLUDED
#define __SDPCI_H_INCLUDED 1

#include "sdbase.h"
#include <string>
#include <vector>

namespace SimpleDetect {


struct DetectedDevicePCI {
	typedef unsigned short id_type;
	id_type vendor_id;
	id_type device_id;
	id_type baseclass_id;
	id_type  subclass_id;
	std::string vendor_name;
	std::string device_name;
	std::string baseclass_name;
	std::string subclass_name;
};
class sdPCIIMPL;

class sdPCI {
public:
	sdPCI(const std::string& ids_path, const std::string map_path);
	~sdPCI();
public:
	void initialize(void);
public:
	typedef enum {
		AUTO,
		FORCE,
		NEVER,
	} load_config_t;
	typedef enum {
		SPECIFIC,
		BRIDGE_PCCARD,
		BUS_USB,
		BUS_FIREWIRE,
		STORAGE_SCSI,
		STORAGE_IDE,
		STORAGE_SATA,
	} known_class_t;
public:
	void setBaseClassBasedLoadConfig  (const std::string& class_substr, load_config_t config);
	void setSubClassBasedLoadConfig   (const std::string& class_substr, load_config_t config);
	void setKnownClassBasedLoadConfig (known_class_t known_class,       load_config_t config);
	void detect(ModuleLoader& loader);
public:
	void showDetectedDevices(std::ostream& stream) const;
	void getDetectedDevices(std::vector<DetectedDevicePCI>& result) const;
private:
	sdPCIIMPL* m_impl;
private:
	sdPCI();
};


}  // namespace SimpleDetect

#endif /* sdpci.h */
