#ifndef __PIPE_H_INCLUDED
#define __PIPE_H_INCLUDED 1

#include <iostream>
#include <map>
#include <list>
#include <boost/utility.hpp>

namespace VIVER {


class MultiPipe : private boost::noncopyable {
public:
	MultiPipe();
	MultiPipe(std::pair<int, int> opened_pipe_pair, std::ostream& output_stream1 = std::cout, std::ostream& output_stream2 = std::cout);
	~MultiPipe();
public:
	void addPipe(int pipe, std::ostream& output_stream = std::cout);
	void addPipe(std::pair<int,int> pipe_pair, std::ostream& output1 = std::cout, std::ostream& output2 = std::cout);
	unsigned int display(bool end_when_one_ends = false);
	void close(void);
private:
	size_t num_pipe;
	typedef std::map<int, std::ostream*> stream_map_t;
	typedef std::list<stream_map_t::key_type> active_pipes_t;
	stream_map_t m_stream_map;
	active_pipes_t m_active_pipes;
private:
	size_t readLine(int fd, char* buf, size_t buf_length);
	unsigned short setActivePipes(fd_set* pipe_set);
};



}  // namespace VIVER

#endif /* pipe.h */
