#include "pipe.h"
#include "display.h"
#include <unistd.h>
#include <errno.h>

namespace VIVER {


// コンストラクタ
MultiPipe::MultiPipe()
{}


MultiPipe::MultiPipe(std::pair<int, int> opened_pipe_pair, std::ostream& output_stream1, std::ostream& output_stream2)
{
	addPipe(opened_pipe_pair.first,  output_stream1);
	addPipe(opened_pipe_pair.second, output_stream2);
}


// デストラクタ
MultiPipe::~MultiPipe()
{
	close();
}


// public:
void MultiPipe::addPipe(std::pair<int, int> opened_pipe_pair, std::ostream& output_stream1, std::ostream& output_stream2)
{
	addPipe(opened_pipe_pair.first,  output_stream1);
	addPipe(opened_pipe_pair.second, output_stream2);
}

void MultiPipe::addPipe(int opened_pipe, std::ostream& output_stream)
{
	if( opened_pipe < 0 ) return;
	std::pair<stream_map_t::iterator, bool> ins(
			m_stream_map.insert(
				stream_map_t::value_type(
					opened_pipe,
					&output_stream
					)
				)
			);
	if( ins.second ) {
		m_active_pipes.push_back(opened_pipe);
	}
}

unsigned int MultiPipe::display(bool end_when_one_ends)
{
	char buf[1025];

	if( m_active_pipes.size() == 0 ) {
		return 0;	// 残存パイプ無し
	} else if( m_active_pipes.size() == 1 ) {
		goto single_pipe;
	}

	// m_active_pipes.size() >= 2
	// 多パイプモード
	fd_set pipe_set;
	unsigned short max_fd;

	unsigned int start_size;    // end_when_one_ends == trueの時にのみ使用
	start_size = 0;
	if( end_when_one_ends ) start_size = m_active_pipes.size();

	max_fd = setActivePipes(&pipe_set);
	while( ::select(max_fd+1, &pipe_set, NULL, NULL, NULL) > 0 ) {  // select()はバグを入れるとデッドロックする。要注意
		// XXX: EINTRチェックが必要
		active_pipes_t::iterator active;
		active = m_active_pipes.begin();
		while( active != m_active_pipes.end() ) {
			if( FD_ISSET(*active, &pipe_set) ) {
				// 読み込み可 -> 読み込み
				if( readLine(*active, buf, sizeof(buf)) > 0 ) {    // XXX: EAGAINチェックが必要？
					// 非EOF
					// FIXME: m_stream[*active]が存在しないときは？ (ただし必ず存在する)
					(*m_stream_map[*active]) << buf << std::flush;
					++active;
				} else {
					// EOF
					active = m_active_pipes.erase(active);
				}
			} else {
				// 読み込み不可
				++active;
			}
		}

		// end_when_one_ends == tureのときは、1本以上のパイプが終了したときに返る(返り値は残存パイプ本数)
		if( end_when_one_ends && start_size != m_active_pipes.size() ) return m_active_pipes.size();

		if( m_active_pipes.size() == 1 ) goto single_pipe;
		else if( m_active_pipes.size() == 0 ) return 0;	// 残存パイプ無し

		max_fd = setActivePipes(&pipe_set);
	}

single_pipe:
	// パイプ1本モード
	int last_pipe = *m_active_pipes.begin();
	std::ostream* last_stream = m_stream_map[last_pipe];    // FIXME: m_stream[*active]が存在しないときは？ (ただし必ず存在する)

	while( readLine(last_pipe, buf, sizeof(buf)) > 0 ) {
		// XXX: EAGAINチェックが必要？
		*last_stream << buf << std::flush;
	}

	m_active_pipes.clear();

	// 残存パイプ無し
	return 0;
}

void MultiPipe::close(void)
{
	for( stream_map_t::iterator pipe( m_stream_map.begin() );
			pipe != m_stream_map.end();
			++pipe ) {
		host::display.debug() << "Close pipe " << pipe->first << std::endl;
		::close( pipe->first );
	}
	m_stream_map.clear();
}


// private:
size_t MultiPipe::readLine(int fd, char* buf, size_t buf_length)
{
	if( (buf_length = ::read(fd, buf, buf_length-1)) > 0 ) {
		buf[buf_length] = '\0';
	}
	return buf_length;
}

unsigned short MultiPipe::setActivePipes(fd_set* pipe_set)
{
	unsigned short max_fd = 0;
	FD_ZERO(pipe_set);
	for(active_pipes_t::iterator active( m_active_pipes.begin() );
			active != m_active_pipes.end();
			++active ) {
		FD_SET(*active, pipe_set);
		if( *active > max_fd ) max_fd = *active;
	}
	return max_fd;
}


}  // namespace VIVER

