#ifndef __PCIMAP_H_INCLUDED
#define __PCIMAP_H_INCLUDED 1

#include "pciids_types.h"
#include "sdbase.h"
#include <list>
#include <vector>
#include <map>

namespace SimpleDetect {


class PCIMap {
public:
	PCIMap(const std::string& map_path);
	~PCIMap();
public:
	void load(void);
public:
	const std::list<std::string> getModuleName(PCIIDTypes::Vendor::id_type vendor_id, PCIIDTypes::Device::id_type device_id) const;
private:
	std::string m_map_path;
	typedef DualID<PCIIDTypes::Vendor::id_type, PCIIDTypes::Device::id_type> vandd_t;
	typedef std::multimap<vandd_t, std::string> map_t;
	map_t m_map;
private:
	PCIMap();
};


}  // namespace SimpleDetect

#endif /* pcimap.h */
