#ifndef __PCIIDS_TYPES_H_INCLUDED
#define __PCIIDS_TYPES_H_INCLUDED 1

#include "nestedmap.h"

namespace SimpleDetect {

namespace PCIIDTypes {


class Device : private NestedMap<void> {
public:
	Device(const std::string& name);
	~Device();
public:
	typedef NestedMap<Device>::child_id_type id_type;
public:
	const std::string& getName(void) const;
private:
	Device();
};


class Vendor : private NestedMap<Device> {
public:
	Vendor(const std::string& name);
	~Vendor();
public:
	typedef NestedMap<Vendor>::child_id_type id_type;
	typedef NestedMap<Device>::child_id_type child_id_type;
	typedef NestedMap<Device>::child_type child_type;
public:
	Device* addDevice(child_id_type id, const std::string& name);
	const std::string& getName(void) const;
	const std::string* getDeviceName(child_id_type id) const;
private:
	Vendor();
};


class VendorDeviceMap : private NestedMap<Vendor> {
public:
	VendorDeviceMap();
	~VendorDeviceMap();
public:
	typedef NestedMap<Vendor>::child_id_type child_id_type;
	typedef NestedMap<Vendor>::child_type child_type;
public:
	Vendor* addVendor(child_id_type id, const std::string& name);
	const std::string* getVendorName(child_id_type id) const;
	const std::string* getDeviceName(child_id_type vendor_id, child_type::child_id_type device_id) const;
};


class SubClass : private NestedMap<void> {
public:
	SubClass(const std::string& name);
	~SubClass();
public:
	typedef NestedMap<SubClass>::child_id_type id_type;
public:
	const std::string& getName(void) const;
private:
	SubClass();
};

class BaseClass : private NestedMap<SubClass> {
public:
	BaseClass(const std::string& name);
	~BaseClass();
public:
	typedef NestedMap<BaseClass>::child_id_type id_type;
	typedef NestedMap<SubClass>::child_id_type child_id_type;
	typedef NestedMap<SubClass>::child_type child_type;
public:
	SubClass* addSubClass(child_id_type id, const std::string& name);
	const std::string& getName(void) const;
	const std::string* getSubClassName(child_id_type id) const;
private:
	BaseClass();
};

class ClassMap : private NestedMap<BaseClass> {
public:
	ClassMap();
	~ClassMap();
public:
	typedef NestedMap<BaseClass>::child_id_type child_id_type;
	typedef NestedMap<BaseClass>::child_type child_type;
public:
	BaseClass* addBaseClass(child_id_type id, const std::string& name);
	const std::string* getBaseClassName(child_id_type id) const;
	const std::string* getSubClassName(child_id_type base_id, child_type::child_id_type sub_id) const;
};


}  // namespace PCIIDTypes

}  // namespace SimpleDetect

#endif /* pciids_types.h */
