#include "pciids_types.h"

namespace SimpleDetect {

namespace PCIIDTypes {


// class Device : private NestedMap<void>
Device::Device(const std::string& name) : NestedMap<void>(name)
{}

Device::~Device()
{}

const std::string& Device::getName(void) const
{
	return NestedMap<void>::getName();
}


// class Vendor : private NestedMap<Device>
Vendor::Vendor(const std::string& name) : NestedMap<Device>(name)
{}

Vendor::~Vendor()
{}

Device* Vendor::addDevice(child_id_type id, const std::string& name)
{
	return addBack(id, name);
}

const std::string& Vendor::getName(void) const
{
	return NestedMap<Device>::getName();
}

const std::string* Vendor::getDeviceName(child_id_type id) const
{
	const Device* found( find(id) );
	if( found ) {
		return &( found->getName() );
	} else {
		return NULL;
	}
}


// class VendorDeviceMap : private NestedMap<Vendor>
VendorDeviceMap::VendorDeviceMap() : NestedMap<Vendor>("")
{}

VendorDeviceMap::~VendorDeviceMap()
{}

Vendor* VendorDeviceMap::addVendor(child_id_type id, const std::string& name)
{
	return addBack(id, name);
}

const std::string* VendorDeviceMap::getVendorName(child_id_type id) const
{
	const Vendor* found( find(id) );
	if( found ) {
		return &( found->getName() );
	} else {
		return NULL;
	}
}

const std::string* VendorDeviceMap::getDeviceName(child_id_type vendor_id, child_type::child_id_type device_id) const
{
	const Vendor* found( find(vendor_id) );
	if( found ) {
		return found->getDeviceName(device_id);
	} else {
		return NULL;
	}
}



// class SubClass : private NestedMap<void>
SubClass::SubClass(const std::string& name) : NestedMap<void>(name)
{}

SubClass::~SubClass()
{}

const std::string& SubClass::getName(void) const
{
	return NestedMap<void>::getName();
}


// class BaseClass : private NestedMap<SubClass>
BaseClass::BaseClass(const std::string& name) : NestedMap<SubClass>(name)
{}

BaseClass::~BaseClass()
{}

SubClass* BaseClass::addSubClass(child_id_type id, const std::string& name)
{
	return addBack(id, name);
}

const std::string& BaseClass::getName(void) const
{
	return NestedMap<SubClass>::getName();
}

const std::string* BaseClass::getSubClassName(child_id_type id) const
{
	const SubClass* found( find(id) );
	if( found ) {
		return &( found->getName() );
	} else {
		return NULL;
	}
}


// class ClassMap : private NestedMap<BaseClass>
ClassMap::ClassMap() : NestedMap<BaseClass>("")
{}

ClassMap::~ClassMap()
{}

BaseClass* ClassMap::addBaseClass(child_id_type id, const std::string& name)
{
	return addBack(id, name);
}

const std::string* ClassMap::getBaseClassName(child_id_type id) const
{
	const BaseClass* found( find(id) );
	if( found ) {
		return &( found->getName() );
	} else {
		return NULL;
	}
}

const std::string* ClassMap::getSubClassName(child_id_type base_id, child_type::child_id_type sub_id) const
{
	const BaseClass* found( find(base_id) );
	if( found ) {
		return found->getSubClassName(sub_id);
	} else {
		return NULL;
	}
}


}  // namespace PCIIDTypes

}  // namespace SimpleDetect

