#ifndef __PATH_H_INCLUDED
#define __PATH_H_INCLUDED 1

#include <string>
#include <vector>

namespace VIVER {


class Path {
public:
	explicit Path(const std::string& path);
	Path();
	~Path();
	inline const std::string& str(void) const { return m_cache; }
	inline const char* c_str(void) const { return m_cache.c_str(); }
	Path& operator+= (const std::string& path);
	Path& operator+= (const Path& path);
	Path& operator= (const std::string& path);
	Path& operator= (const char* path)
		{ return operator=( (path == NULL ? std::string() : std::string(path)) ); }
	Path operator+ (const std::string& path) const;
	Path operator+ (const Path& path) const;
	Path chroot(const std::string& root) const;
	inline bool empty(void) const { return m_cache.empty(); }
	void cache(void);
	bool isChildOf(const Path& parent) const;
private:
	std::vector<std::string> m_relative;
	std::string m_cache;
};


}  // namespace VIVER

#endif /* path.h */
