#ifndef __PARAMETERS_H_INCLUDED
#define __PARAMETERS_H_INCLUDED 1

#include <map>
#include <string>
#include <utility>
#include <boost/utility.hpp>

namespace VIVER {


class Parameters : private boost::noncopyable {
public:
	explicit Parameters(const std::string& boot_parameter_file);	// throw(NoSuchFileError)
	~Parameters();		// throw()
	void parse(void);	// throw()
public:
	typedef enum {
		KB_UNIT,
		MB_UNIT,
		GB_UNIT,
		TB_UNIT,
		INVALID_UNIT,
	} byte_unit_t;
	typedef std::pair<unsigned long, byte_unit_t> with_unit_t;
public:
	const char* getValueString (const char* key, const char* default_value) const;	// throw()
	bool	    getValueBool   (const char* key, bool        default_value) const;	// throw()
	int	    getValueInt    (const char* key, int         default_value) const;	// throw()
	double	    getValueDouble (const char* key, double      default_value) const;	// throw()
	with_unit_t getValueByte(const char* key, with_unit_t default_value) const;	// throw()
	void writeToFile(const std::string& dir) const;		// throw()
private:
	const std::string& m_boot_parameter_file;
	typedef std::map<std::string, std::string> valmap_t;
	typedef std::map<std::string, valmap_t> parameters_t;
	parameters_t m_parameters;
private:
	void writeToFileFormat(const std::string& dir,
			const char* file_suffix,
			const char* parameter_format,
			const char* system_format,
			const char* header, const char* footer) const;	// throw()
	void writeToFileCompatible(const std::string& dir) const;	// throw()
private:
	Parameters();				// デフォルトコンストラクタを禁止
};


}  // namespace VIVER

#endif /* parameters.h */
