#ifndef __NESTEDMAP_H_INCLUDED
#define __NESTEDMAP_H_INCLUDED 1

#include <map>
#include <string>
#include <iterator>

#include <iostream>

namespace SimpleDetect {


template <typename ChildMap>
class NestedMap {
public:
	NestedMap(const std::string& name) :
		m_name(name)
	{}
	virtual ~NestedMap()
	{}
public:
	typedef ChildMap child_type;
	typedef unsigned short child_id_type;
public:
	child_type* add(child_id_type id, const std::string& name)
	{
		std::pair<typename map_t::iterator, bool> ins(
				m_map.insert(
					std::make_pair(id, child_type(name))
					)
				);
		if( ins.second ) {
			// map_t::iterator  ins.first
			// child_map        ins.first->second
			return &(ins.first->second);
		} else {
			return NULL;
		}
	}

	child_type* addBack(child_id_type id, const std::string& name)
	{
		typename map_t::size_type before( m_map.size() );
		typename map_t::iterator last_elem( m_map.begin() );
		if( ! m_map.empty() ) {
			std::advance(last_elem, m_map.size()-1);
		}
		typename map_t::iterator ins(
				m_map.insert(
					last_elem,
					std::make_pair(id, child_type(name))
					)
				);
		typename map_t::size_type after( m_map.size() );
		if( before < after ) {
			// insert成功
			return &(ins->second);
		} else {
			// insert失敗
			return NULL;
		}
	}

	const child_type* find(child_id_type id) const
	{
		return find_impl(id);
	}

	child_type* find(child_id_type id)
	{
		return const_cast<child_type*>( find_impl(id) );
	}

	const std::string& getName(void) const
	{
		return m_name;
	}

private:
	const child_type* find_impl(child_id_type id) const
	{
		typename map_t::const_iterator found( m_map.find(id) );
		if( found != m_map.end() ) {
			return &(found->second);
		} else {
			return NULL;
		}
	}

private:
	std::string m_name;
	typedef std::map<child_id_type, child_type> map_t;
	map_t m_map;
};



template <>
class NestedMap<void> {
public:
	NestedMap(const std::string& name) :
		m_name(name)
	{}
	virtual ~NestedMap()
	{}
public:
	const std::string& getName(void) const
	{
		return m_name;
	}
private:
	std::string m_name;
};



}  // namespace SimpleDetect

#endif /* nestedmap.h */
