#include "modules.h"
#include "constant.h"
#include "display.h"
#include "process.h"

namespace VIVER {


void Modules::loadModule(const char* module)
{
	host::display.notice() << "Loading module: " << module << std::endl;
	Process ps_modprobe(Component::Program::MODPROBE);
	ps_modprobe % module;
	MultiPipe mp( ps_modprobe.exec(true,true), host::display.debug(), host::display.verbose() );
	mp.display();
	ps_modprobe.wait();
}

void Modules::loadModule(const char** modules)
{
	for( const char** mod( &modules[0] );
			*mod != NULL;
			++mod ) {
		loadModule(*mod);
	}
}

void Modules::loadModule(const std::string& module)
{
	loadModule(module.c_str());
}

void Modules::loadModule(const std::vector<std::string>& modules)
{
	for( std::vector<std::string>::const_iterator mod( modules.begin() );
			mod != modules.end();
			++mod ) {
		loadModule( mod->c_str() );
	}
}

void Modules::moduleLoader(const std::string& module)
{
	return loadModule(module.c_str());
}


void Modules::LoadModuleSD::operator() (const std::string& module)
{
	loadModule(module.c_str());
}


}  // namespace VIVER
