#include "log.h"
#include <syslog.h>

namespace VIVER {


// 定数
const int LogControler::message_loglevel[] = {
	LOG_DEBUG,
	LOG_INFO,
	LOG_NOTICE,
	LOG_ERR,
	LOG_ALERT,
};


// コンストラクタ
LogControler::LogControler()
{
	::openlog("VIVER", 0, LOG_USER);
}


// デストラクタ
LogControler::~LogControler()
{
	::closelog();
}


// public:
void LogControler::write(const char* msg, Display::message_priority level)
{
	::syslog(message_loglevel[level], "%s", msg);
}


}  // namespace VIVER

