#include "fallback.h"
#include "exception.h"
#include "display.h"
#include "shell.h"
#include "constant.h"
#include "filesystem.h"
#include "path.h"
#include <fstream>
#include <exception>
#include <stdexcept>

namespace VIVER {


void FallBack::toShell(boost::function<void (std::string)> func, std::string command)
{
	try {
		func( command );
	}
	catch(const std::runtime_error& ex) {
		host::display.error() << ex.what() << std::endl;

		Path cmdfile_path( Component::Resource::TEMPORARY_DIR + "viver.cmd" );
		FileSystem::remove(cmdfile_path);

		// シェル起動
		Shell shell;
		shell.execShell( cmdfile_path.str() );

		// ユーザーからのコマンドを読み込む
		std::ifstream cmdfile( cmdfile_path.c_str() );

		std::string next_command;
		if( cmdfile.is_open() ) {
			char buf[1024];
			cmdfile.getline(buf, sizeof(buf));
			next_command = buf;
		}

		// リトライ
		toShell(func, next_command);
	}
}


}  // namespace VIVER
