#ifndef __EXCEPTION_H_INCLUDED
#define __EXCEPTION_H_INCLUDED 1

#include <exception>
#include <stdexcept>
#include <string>
#include <errno.h>

#define VIVER_MakeRuntimeError( name )			\
class name : public std::runtime_error {		\
public:							\
	name(const char* message) :			\
		runtime_error(message)			\
	{}						\
	name(const std::string& message) :		\
		runtime_error(message)			\
	{}						\
}							\


namespace VIVER {


VIVER_MakeRuntimeError( NoSuchFileError );
extern const std::string CANNOT;
inline std::string errorDescribe(void)
{
	return std::string(": ") + ::strerror(errno);
}


}  // namespace VIVER

#endif /* exception.h */
