#ifndef __DISPLAY_MAPPER_H_INCLUDED
#define __DISPLAY_MAPPER_H_INCLUDED 1

#include "display.h"
#include "console.h"
#include "log.h"
#include "union_buffer.h"
#include "exception.h"
#include <iostream>
#include <boost/utility.hpp>

namespace VIVER {


template <Display::message_priority L> class DisplayMapper : private boost::noncopyable {
public:
	DisplayMapper(ConsoleControler& console, LogControler& log) :
		m_console(console),
		m_log(log),
		m_console_start(false),
		m_log_start(false),
		m_union_buffer(),
		m_formatter(&m_union_buffer)
	{}
//	~DisplayMapper();
public:
	void startConsole(void)
	{
		if( m_console_start ) return;
		m_console_id = m_union_buffer.addWriter(
				boost::bind(&ConsoleControler::write, &m_console, _1, L)
				);
		m_console_start = true;
	}
	void startLog(void)
	{
		if( m_log_start ) return;
		m_log_id = m_union_buffer.addWriter(
				boost::bind(&LogControler::write, &m_log, _1, L)
				);
		m_log_start = true;
	}
	void stopConsole(void)
	{
		if( !m_console_start ) return;
		m_union_buffer.removeWriter( m_console_id );
		m_console_start = false;
	}
	void stopLog(void)
	{
		if( !m_log_start ) return;
		m_union_buffer.removeWriter( m_log_id );
		m_log_start = false;
	}
	inline std::ostream& get(void) { return m_formatter; }
private:
	ConsoleControler& m_console;
	LogControler& m_log;
	bool m_console_start;
	bool m_log_start;
	UnionStreamBuffer m_union_buffer;
	UnionStreamBuffer::WriterID m_console_id;
	UnionStreamBuffer::WriterID m_log_id;
	std::ostream m_formatter;
};


}  // namespace VIVER

#endif /* displaymanager.h */
