#ifndef __DISPLAY_IMPL_H_INCLUDED
#define __DISPLAY_IMPL_H_INCLUDED 1

#include "color.h"
#include "console.h"
#include "log.h"
#include "display_mapper.h"
#include <iostream>

namespace VIVER {


class DisplayIMPL {
public:
	DisplayIMPL();
	~DisplayIMPL();
public:
	void configure(const Parameters& parameters);
	inline std::ostream& debug(void)   { return m_dm_debug.get();   }
	inline std::ostream& verbose(void) { return m_dm_verbose.get(); }
	inline std::ostream& notice(void)  { return m_dm_notice.get();  }
	inline std::ostream& warn(void)    { return m_dm_warn.get();    }
	inline std::ostream& error(void)   { return m_dm_error.get();   }
private:
	ConsoleControler m_console;
	LogControler m_log;
	DisplayMapper<Display::DEBUG>   m_dm_debug;
	DisplayMapper<Display::VERBOSE> m_dm_verbose;
	DisplayMapper<Display::NOTICE>  m_dm_notice;
	DisplayMapper<Display::WARN>    m_dm_warn;
	DisplayMapper<Display::ERROR>   m_dm_error;
private:
	void hidePrintk(void);
	void showPrintk(void);
};


}  // namespace VIVER

#endif /* display_impl.h */
