#ifndef __DISPLAY_H_INCLUDED
#define __DISPLAY_H_INCLUDED 1

#include "parameters.h"
#include <iostream>

namespace VIVER {




class DisplayIMPL;

class Display {
public:
	Display();
	~Display();
public:
	void configure(const Parameters& parameters);	// throw()
	std::ostream& debug(void);		// throw()
	std::ostream& verbose(void);		// throw()
	std::ostream& notice(void);		// throw()
	std::ostream& warn(void);		// throw()
	std::ostream& error(void);		// throw()
public:
	typedef enum {
		DEBUG   = 0,
		VERBOSE = 1,
		NOTICE  = 2,
		WARN    = 3,
		ERROR   = 4,
	} message_priority;
private:
	DisplayIMPL *m_impl;
};


namespace host {
	extern Display display;
}


}  // namespace VIVER

#endif /* display.h */
