#ifndef __DEVICENODE_H_INCLUDED
#define __DEVICENODE_H_INCLUDED 1

#include "mountable.h"
#include "path.h"
#include <string>

namespace VIVER {


class DeviceNode : public Mountable {
public:
	// まだマウントしていないDeviceNodeを作成
	DeviceNode(FileSystem::major_t major, FileSystem::minor_t minor,
			const Path& dev_path, const std::string& node_name,
			const std::string& fstype, unsigned long mount_flags, const std::string& data_string);
			// throw()

	// 既にマウント済みのDeviceNodeを作成
	DeviceNode(FileSystem::major_t major, FileSystem::minor_t minor,
			const Path& dev_path, const std::string& node_name,
			const std::string& fstype, unsigned long mount_flags, const std::string& data_string,
			const Path& mount_point);
			// throw()

	~DeviceNode();
public:
	// Mountableインターフェース
	void mount(const Path& mount_point);		// throw(MountError)
	void umount(void);				// throw(MountError)
	void move(const Path& mount_point);		// throw(MountError)
	void remount(unsigned long mount_flags, const std::string& data_string);	// throw(MountError)
	void remount(const std::string& hand_options);	// throw(MountError)
public:
	int makeNode(void);				// throw()
	int makeNodeOn(const Path& dev_path);		// throw()
	Path getNodePathOn(const Path& dev_path) const	// throw()
	{ return dev_path + m_node_name; }

	FileSystem::major_t getMajor(void) const { return m_major; }		// throw()
	FileSystem::minor_t getMinor(void) const { return m_minor; }		// throw()
	Path getNodePath(void) const { return m_dev_path + m_node_name; }	// throw()
	const std::string& getNodeName(void) { return m_node_name; }		// throw()

	// byte単位のサイズを返す エラーなら0を返す
	uint64_t getSize(void);			// throw()
private:
	const FileSystem::major_t m_major;
	const FileSystem::minor_t m_minor;
	const Path& m_dev_path;
	const std::string m_node_name;
public:
	DeviceNode();					// デフォルトコンストラクタを禁止
};


}  // namespace VIVER

#endif /* devicenode.h */
