#ifndef __CONSTANT_H_INCLUDE
#define __CONSTANT_H_INCLUDED 1

#include "path.h"
#include "filesystem.h"
#include <string>

namespace VIVER {

namespace host {
	extern bool debug_mode;
}

extern const std::string VERSION;
extern const std::string PARAMETER_NAMESPACE;

namespace Component {
	namespace MountPoint {
		extern const Path PROC;
		extern const Path SYS;
		extern const Path ARK;
		extern const Path MODULE_DISK;
		extern const Path FORMED;
	}
	namespace Formed {
		extern const Path MP_ARK;
		extern const Path MP_SYS;
		extern const Path MP_PROC;
	}
	namespace Ark {
		extern const Path BIN;
		extern const Path DEV;
		extern const Path MP_BOOTDISK;
		extern const Path MP_COMPRESSED;
		extern const Path MP_SCREEN;
		extern const Path MP_SCREEN_CONTAINER;
		extern const Path MP_TORAM;
	}
	namespace Resource {
		extern const Path MOUNT_TRIAL_POINT;
		extern const Path TEMPORARY_DIR;
		extern const Path MODULE_DISK;
		extern const std::string FSTYPE_MODULE_DISK;
		extern const char* PATH_DHCP_SCRIPT;
		extern const char* PATH_ZCIP_SCRIPT;
		extern const std::string PCIMAP;
		extern const std::string PCI_IDS;
		extern const std::string USBMAP;
		extern const std::string USB_IDS;
	}
	namespace Image {
		extern const std::string FSTYPE_FIXED;
		extern const std::string FSTYPE_COMPRESSED;
	}
	namespace Kernel {
		extern const char* PATH_BOOT_PARAMETER_FILE;
		extern const char* PATH_SYS_NET_DIR;
		extern const char* PATH_SYS_BLOCK_DIR;

		extern const char* PATH_PROC_PARTITIONS;
		extern const char* PATH_PROC_REALROOT;
		extern const char* PATH_PROC_PRINTK;
		extern const char* PATH_PROC_MEMINFO;

		extern const std::string PROC_PCI;
		extern const std::string PROC_USB;

		extern const FileSystem::major_t LOOP_MAJOR;
		extern const FileSystem::minor_t LOOP_MIN;
		extern const FileSystem::minor_t LOOP_MAX;
	}
	namespace Program {
		extern const char* MODPROBE;
		extern const char* LOSETUP;
		extern const char* IFCONFIG;
		extern const char* UDHCPC;
		extern const char* ZCIP;
		extern const char* CARDMGR;
		extern const char* NBD_CLIENT;
		extern const char* BACK_EXEC;
		extern const char* VFIELD;
		extern const char* BLOCKDEV;
		extern const char* DD;
		extern const char* COWDEV;
		extern const char* COWREPAIR;
		extern const char* XFS_GROWFS;
		extern const char* TABLEFILING;
		extern const char* DMSETUP;
		extern const char* SYSLOGD;
		extern const char* KILLALL;
	}
	namespace UserMessage {
		extern const int RETRY;
		extern const int NEXT;
		extern const int HALT;
		extern const int EXEC_ERROR;
		// 上記以外は IGNORE
	}
}

namespace DefaultInfo {
	namespace Ark {
		extern const std::string MOUNT_DATA_STRING;
	}
	namespace Image {
		extern const char* COMPRESSED_ON_BOOTDISK;
		extern const char* FIXED_ON_COMPRESSED;
		extern const char* SHADOW_ON_SCREEN;
		extern const char* SPARSE_ON_SCREEN;
		extern const char* FSTYPE_SCREEN_CONTAINER;
	}
	namespace SharedBlock {
		extern const char* PORT;
	}
	namespace Formed {
		extern const char* RC_PATH;
		extern const char* PARAMETER_OUTPUT_DIR;
		extern const char* PIVOT_OLD_DIR;
	}
}

namespace MP = Component::MountPoint;
namespace ARK = Component::Ark;
namespace FORMED = Component::Formed;


}  // namespace VIVER

#endif
