#include "constant.h"

namespace VIVER {

namespace host {
	bool debug_mode = false;
}

const std::string VERSION("0.3");
const std::string PARAMETER_NAMESPACE("VIVER");

namespace Component {
	namespace MountPoint {
		const Path PROC			("proc");
		const Path SYS			("sys");
		const Path ARK			("VIVER");
		const Path MODULE_DISK		("lib/modules");
		const Path FORMED		("sysroot");
	}
	namespace Formed {
		const Path MP_ARK		("VIVER");
		const Path MP_SYS		("sys");
		const Path MP_PROC		("proc");
	}
	namespace Ark {
		const Path BIN			("bin");
		const Path DEV			("dev");
		const Path MP_BOOTDISK		("disk");
		const Path MP_COMPRESSED	("compressed");
		const Path MP_SCREEN		("screen");
		const Path MP_SCREEN_CONTAINER	("container");
		const Path MP_TORAM		("toram");
	}
	namespace Resource {
		const Path MOUNT_TRIAL_POINT	("trial");
		const Path TEMPORARY_DIR	("tmp");
		const Path MODULE_DISK		("modules.squash");
		const std::string FSTYPE_MODULE_DISK ("squashfs");
		const char* PATH_DHCP_SCRIPT = "/etc/dhcp-script";
		const char* PATH_ZCIP_SCRIPT = "/etc/zcip-script";
		const std::string PCI_IDS("/usr/share/pci.ids");
		const std::string USB_IDS("/usr/share/usb.ids");
	}
	namespace Image {
		const std::string FSTYPE_FIXED = "xfs";
		const std::string FSTYPE_COMPRESSED = "squashfs";
	}
	namespace Kernel {
		const char* PATH_BOOT_PARAMETER_FILE = "/proc/cmdline";
		const char* PATH_SYS_NET_DIR = "/sys/class/net";
		const char* PATH_SYS_BLOCK_DIR = "/sys/block";

		const char* PATH_PROC_PARTITIONS = "/proc/partitions";
		const char* PATH_PROC_REALROOT = "/proc/sys/kernel/real-root-dev";
		const char* PATH_PROC_PRINTK = "/proc/sys/kernel/printk";
		const char* PATH_PROC_MEMINFO = "/proc/meminfo";

		const std::string PROC_PCI("/proc/bus/pci");
		const std::string PROC_USB("/proc/bus/usb");

		const FileSystem::major_t LOOP_MAJOR = 7;
		const FileSystem::minor_t LOOP_MIN = 100;
		const FileSystem::minor_t LOOP_MAX = 255;
	}
	namespace Program {
		const char* MODPROBE = "/sbin/modprobe";
		const char* LOSETUP = "/sbin/losetup";
		const char* IFCONFIG = "/sbin/ifconfig";
		const char* UDHCPC = "/bin/udhcpc";
		const char* ZCIP = "/bin/zcip";
		const char* CARDMGR = "/sbin/cardmgr";
		const char* NBD_CLIENT = "/bin/nbd-client";
		const char* BACK_EXEC = "/bin/back-exec";
		const char* VFIELD = "/bin/vfield";
		const char* BLOCKDEV = "/bin/blockdev";
		const char* DD = "/bin/dd";
		const char* COWDEV = "/sbin/cowdev";
		const char* COWREPAIR = "/sbin/cowrepair";
		const char* XFS_GROWFS = "/sbin/xfs_growfs";
		const char* TABLEFILING = "/bin/tablefiling";
		const char* DMSETUP = "/sbin/dmsetup";
		const char* SYSLOGD = "/sbin/syslogd";
		const char* KILLALL = "/bin/killall";
	}
	namespace UserMessage {
		const int RETRY = 128;
		const int NEXT = 129;
		const int HALT = 130;
		const int EXEC_ERROR = 127;
		// 上記以外は IGNORE
	}
}

namespace DefaultInfo {
	namespace Ark {
		const std::string MOUNT_DATA_STRING = "size=3m";
	}
	namespace Image {
		const char* COMPRESSED_ON_BOOTDISK = "fixed.squash";
		const char* FIXED_ON_COMPRESSED = "fixed.img";
		const char* SHADOW_ON_SCREEN = "shadow.img";
		const char* SPARSE_ON_SCREEN = "sparse.img";
		const char* FSTYPE_SCREEN_CONTAINER = "ext3";
	}
	namespace SharedBlock {
		const char* PORT = "19660";
	}
	namespace Formed {
		const char* RC_PATH = "/etc/viverrc";
		const char* PARAMETER_OUTPUT_DIR = "/etc/VIVER/output/VIVER";
		const char* PIVOT_OLD_DIR = "/initrd";
	}
}


}  // namespace VIVER
