#ifndef VFIELD_THREADPOOL_H__
#define VFIELD_THREADPOOL_H__

#include "log.h"
#include "exception.h"
#include <boost/ptr_container/ptr_vector.hpp>
#include <boost/ptr_container/ptr_deque.hpp>
#include <boost/thread.hpp>
#include <boost/function.hpp>
#include <boost/bind.hpp>	// 使う側で便利用

// FIXME: boost/thread関連の例外処理をしていない
// FIXME: スレッドの最大数が指定できない

namespace VFIELD {


////
// ThreadPool
//
class ThreadPool {
public:
	ThreadPool(unsigned short initial_threads);
	~ThreadPool();
public:
	typedef boost::function<void (void)> task_type;
	inline void submitTask(const task_type& task);
	void addThreads(unsigned short num);
	void addThread(void);
public:
	void joinThreads(void);
private:
	volatile bool m_end_flag;

	void WorkerThread(void);

	boost::ptr_vector<boost::thread> threads_pool;
	boost::mutex pool_mutex;

	boost::ptr_deque<task_type> task_queue;
	unsigned short ready_threads;
	boost::mutex queue_mutex;

	boost::condition ring_cond;
	boost::mutex ring_mutex;
private:
	ThreadPool();
};


void ThreadPool::submitTask(const task_type& task)
{
	// タスクを追加
	{
		boost::mutex::scoped_lock lk_queue(queue_mutex);
		task_queue.push_back( new task_type(task) );
	}

	// 待っているスレッドを1つ開始
	{
		boost::mutex::scoped_lock lk_ring(ring_mutex);
		ring_cond.notify_one();
	}

	// 待機スレッドが少なすぎる場合は、スレッドを追加
	if( ready_threads < 2 ) {
		addThread();
	}
}


}  // namespace VFIELD

#endif /* threadpool.h */
