#include "rw_lock.h"
#include <iostream>

using namespace VFIELD;

int val;
rw_mutex mutex;

void writer(void)
{
	sleep(1);
	{
		std::cout << "writer trying to lock" << std::endl;
		write_scoped_lock lk(mutex);
		std::cout << "writing 10..." << std::endl;
		sleep(4);
		val = 10;
	}
	sleep(3);
	{
		std::cout << "writer trying to lock" << std::endl;
		write_scoped_lock lk(mutex);
		std::cout << "writing 1..." << std::endl;
		sleep(3);
		val = 1;
	}
}

void reader1(void)
{
	for(int i=0; i < 10; i++) {
		std::cout << "reader1 trying to lock" << std::endl;
		read_scoped_lock lk(mutex);
		std::cout << "reader1 locked" << std::endl;
		std::cout << "reader1: " << val << std::endl;
		std::cout << "reader1 unlocked" << std::endl;
		sleep(1);
	}
}


void reader2(void)
{
	for(int i=0; i < 10; i++) {
		std::cout << "reader2 trying to lock" << std::endl;
		read_scoped_lock lk(mutex);
		std::cout << "reader2 locked" << std::endl;
		sleep(1);
		std::cout << "reader2: " << val << std::endl;
		std::cout << "reader2 unlocked" << std::endl;
	}
}

int main(void)
{
	val = 0;
	boost::thread r2(&reader2);
	boost::thread r1(&reader1);
	boost::thread w(&writer);
	r1.join();
	r2.join();
	w.join();
}
