#include "log.h"
#include "exception.h"
#include "threadpool.h"
#include "node.h"
#include "ip46.h"
#include <boost/bind.hpp>
#include <iostream>

using namespace VFIELD;

void ReadAndPrint(int sock)
{
	char buf[50];
	ssize_t len;
	while(1) {
		len = ::read(sock, buf, sizeof(buf));
		if( len <= 0 ) break;
		buf[len] = '\0';
		std::cout << buf << std::endl;
	}
	::close(sock);
}

int main(void)
{
	ThreadPool pool(5);

	LogDebug("NodeIdentity Constructor Test");
	NodeIdentity node("::1", "10");
	std::cout << "address: " << node.addressString() << std::endl;
	std::cout << "port: " << node.getPortHostByteOrder() << std::endl;


	int sock = listenTCP46("12345");
	LogDebug("Listen at 12345");
	if( sock < 0 ) {
		std::cout << errnoString(errno);
		std::cout << "listen() error" << std::endl;
		abort();
	}


	addr46_t from;
	while(1) {
		int n = accept46(sock, &from);
		pool.submitTask( boost::bind(&ReadAndPrint, n) );
	}

	::close(sock);
	return 0;
}
