#ifndef VFIELD_EXCEPTION_H__
#define VFIELD_EXCEPTION_H__

#include <exception>
#include <stdexcept>
#include <string>
#include <cstring>
#include <errno.h>

namespace VFIELD {


inline char* errnoString(char* buf, size_t buflen)
{ return ::strerror_r(errno, buf, buflen);  }	// GNU拡張

inline char* errnoString(int errno_, char* buf, size_t buflen)
{ return ::strerror_r(errno_, buf, buflen); }	// GNU拡張


class SystemCallException : public std::runtime_error {
private:
	static const size_t BUF_LEN = 1024;
public:
	SystemCallException(int errno_, const std::string& message) :
		std::runtime_error( message + ": " + errnoString(errno_, m_buf, BUF_LEN) )
	{}
private:
	char m_buf[BUF_LEN];
private:
	SystemCallException();
};


}  // namespace VFIELD

#endif /* exception.h */
