#include "receptor.h"
#include "bufferedreq.h"
#include "exception.h"
#include "log.h"
#include <cstring>
#include <algorithm>

namespace VFIELD {


// DataReceptor
DataReceptor::DataReceptor(const BufferedRequest& source, DataRequest& target) :
	m_source(source),
	m_target(target)
{}
DataReceptor::~DataReceptor() {}

void DataReceptor::waitAndCopy(void)
{
	LogDebug0( Log::format("Waiting data %1%...")
		   % DataRange(	std::max(m_source.start(), m_target.start()),
				std::min(m_source.end(),   m_target.end()) )
		   );
	NotifyClient<BufferedRequest::status_type> recv( m_source.getClient() );

	// sourceとtargetの先頭と末尾で、狭い方を取った範囲でコピー
	pos_type use_start = std::max(m_source.start(), m_target.start());
	pos_type use_end = std::min(m_source.end(), m_target.end());

	BufferedRequest::status_type ret( recv.wait() );
	if( ret != BufferedRequest::SUCCESS ) {
		throw DataLostException("...Waiting data is lost");
	}

	::memcpy(	m_target.buffer() + (use_start - m_target.start()),
			m_source.data()   + (use_start - m_source.start()),
			(use_end - use_start + 1)
		);

	LogDebug0( Log::format("...Data %1% is reached")
		   % DataRange(	std::max(m_source.start(), m_target.start()),
				std::min(m_source.end(),   m_target.end()) )
		   );
}


}  // namespace VFIELD
