#include "limited_cache.h"
#include <vector>


namespace VFIELD {


LimitedCache::LimitedCache(pos_type hardlimit, pos_type softlimit) :
	m_cached_size(0), m_hardlimit(hardlimit), m_softlimit(softlimit)
{
	if( m_softlimit < m_hardlimit ) {
		throw InvalidLimitException("Softlimit must be larger than hardlimit");
	}
}

LimitedCache::~LimitedCache() {}


void LimitedCache::checkHardLimit(void)
{
	while( m_cached_size > m_hardlimit && !m_link.empty() ) {
		// hardlimitを超えているのでデータを削除
		link_iterator remove( --m_link.end() );		// XXX: 危険？
		LogDebug0( Log::format("Erasing data: %1%, cached size: %2% bytes") % (**--m_link.end()) % (m_cached_size - (*remove)->size()) );
		m_cached_size -= (*remove)->size();
		m_link.erase(remove);
	}
}


}  // namespace VFIELD
