#ifndef __VERSION_H_INCLUDED
#define __VERSION_H_INCLUDED 1

#include <string>
#include <vector>
#include <boost/optional.hpp>

namespace RUNES {


class Version {
public:
	Version(const std::string& version_string);
	Version();
	~Version();
public:
	typedef unsigned int value_t;
public:
	bool operator<  (const Version& rhl);
	bool operator>  (const Version& rhl);
	bool operator== (const Version& rhl);
public:
	std::string str(void) const;
private:
	std::vector<value_t> m_version;
};


class VersionRange {
public:
	VersionRange(const std::string& range_string);
	~VersionRange();
public:
	bool isSatisfy(const Version& target) const;
private:
	typedef enum {
		EQ_EQ,
		EQ_NEQ,
		NEQ_EQ,
		NEQ_NEQ,
	} version_range_t;
	version_range_t m_range_type;
	boost::optional<Version> m_min_version;
	boost::optional<Version> m_max_version;
private:
	VersionRange();
};


}  // namespace RUNES

#endif /* version.h */
