#ifndef __SAX_TO_DOM_H_INCLUDED
#define __SAX_TO_DOM_H_INCLUDED 1

#include "sax.h"
#include <deque>

namespace RUNES {

class Element;


class SAXtoDOM : public SAX {
public:
	SAXtoDOM(std::istream& source_stream, Element* result);
	~SAXtoDOM();
private:
	void initializer(void);
	void finalizer(void);
	void startElementHandler(const std::string& name, const attributes_t& attributes);
	void endElementHandler(const std::string& name);
	void textHandler(const std::string& text);
	void errorHandler(const std::string& message, unsigned long long line, unsigned long long column);
private:
	Element* getTopElement(void);
private:
	// parsing context
	std::deque<Element*> m_path;

	// parsed result
	Element* m_document;
};


}  // namespace RUNES

#endif /* sax_to_dom.h */
