#include "sax_to_dom.h"
#include "element.h"
#include "exception.h"
#include <sstream>
#include <boost/lexical_cast.hpp>

#include <iostream>

namespace RUNES {


// メタデータ
SAXtoDOM::SAXtoDOM(std::istream& source_stream, Element* result) :
	SAX(source_stream),
	m_document(result)
{}


// デストラクタ
SAXtoDOM::~SAXtoDOM()
{}

// private:
Element* SAXtoDOM::getTopElement(void)
{
	if( m_path.empty() ) {
		return m_document;
	}
	return *(m_path.rbegin());
}

// private:
void SAXtoDOM::initializer(void)
{
}

void SAXtoDOM::finalizer(void)
{
}

void SAXtoDOM::startElementHandler(const std::string& name, const attributes_t& attributes)
{
	Element new_element(name);
	for(attributes_t::const_iterator attr(attributes.begin()), attr_end(attributes.end());
				attr != attr_end;
				++attr ) {
		new_element.appendAttribute(attr->first, attr->second);
	}
	m_path.push_back( &(getTopElement()->appendChild(new_element)) );
}

void SAXtoDOM::endElementHandler(const std::string& name)
{
	m_path.pop_back();
}

void SAXtoDOM::textHandler(const std::string& text)
{
	getTopElement()->appendText(text);
}

void SAXtoDOM::errorHandler(const std::string& message, unsigned long long line, unsigned long long column)
{
	std::cout << "XML Parse Error in " << line << ":" << column << " :  " << message << std::endl;
}


}  // namespace Manager
