#ifndef __RUNEMGR_H_INCLUDED
#define __RUNEMGR_H_INCLUDED 1

#include "metadb.h"
#include "exception.h"
#include <string>
#include <list>
#include <map>
#include <boost/function.hpp>
#include <boost/utility.hpp>

namespace RUNES {

class BundleManager;


namespace Manager {


class Rune;

class RuneManager : private boost::noncopyable {
public:
	RuneManager(const MetaDB& metadb);
	~RuneManager();
public:
	void initialize(void);
public:
	const std::list<const Rune*> getInstallDependency(
		const Rune* target,
		const BundleManager& bmgr,
		boost::function<const Rune* (std::list<const Rune*>*)> askmethod
		) const;
	const Rune* find(const std::string name) const;
	const std::list<const Rune*> getList(void) const;
	const std::string getBaseURL(void) const;
private:
	const MetaDB& m_metadb;
	typedef std::map<std::string, Rune> name_rune_map_t;
	name_rune_map_t m_runes;
private:
	RuneManager();		// デフォルトコンストラクタ禁止
};


}  // namespace Manager

}  // namespace RUNES

#endif /* runemgr.h */
