#ifndef __ROLEMGR_IMPL_H_INCLUDED
#define __ROLEMGR_IMPL_H_INCLUDED 1

#include <string>
#include <list>
#include <map>

namespace RUNES {


class Role;

class RoleManagerIMPL {
public:
	explicit RoleManagerIMPL(const std::string& roles_dir);
	~RoleManagerIMPL();
public:
	void initialize(void);
public:
	const Role* find(const std::string& name) const;
	const std::string& getBaseDir(void) const;
	const std::list<const Role*> getList(void) const;
	void show(void) const;
private:
	const std::string m_roles_dir;
	typedef std::map<std::string, Role> name_role_map_t;
	name_role_map_t m_roles;
private:
	RoleManagerIMPL();
};


}  // namespace RUNES

#endif /* rolemgr_impl.h */
