#include "rolemgr_impl.h"
#include "role.h"
#include "exception.h"
#include <sys/types.h>
#include <dirent.h>

#include <iostream>

namespace RUNES {


// コンストラクタ
RoleManagerIMPL::RoleManagerIMPL(const std::string& roles_dir) :
	m_roles_dir(roles_dir)
{}


// デストラクタ
RoleManagerIMPL::~RoleManagerIMPL() {}


// public:
void RoleManagerIMPL::initialize(void)
{
	DIR *dir_roles;
	dir_roles = ::opendir( m_roles_dir.c_str() );
	if( dir_roles == NULL ) {
		throw std::runtime_error( std::string("Can't open ") + m_roles_dir );
	}

	struct dirent* di;
	while( (di = ::readdir(dir_roles)) != NULL ) {
		const std::string dirname(di->d_name);
		if( dirname == "." || dirname == ".." ) continue;

		try {	// XXX: 例外のクラスを作る
			Role role(m_roles_dir + "/" + dirname);
			role.initialize();	// XXX: throw
			m_roles.insert( std::make_pair(dirname, role) );	// class Role のコピー演算
		}
		catch( const std::runtime_error& ex ) {
			// XXX: 例外処理？
		}
	}

	::closedir(dir_roles);
}

const Role* RoleManagerIMPL::find(const std::string& name) const
{
	name_role_map_t::const_iterator found( m_roles.find(name) );
	if( found == m_roles.end() ) {
		return NULL;
	} else {
		return &(found->second);
	}
}

const std::string& RoleManagerIMPL::getBaseDir(void) const
{
	return m_roles_dir;
}

const std::list<const Role*> RoleManagerIMPL::getList(void) const
{
	std::list<const Role*> list;
	for( name_role_map_t::const_iterator rl( m_roles.begin() );
			rl != m_roles.end();
			++rl ) {
		list.push_back( &(rl->second) );
	}
	return list;
}

void RoleManagerIMPL::show(void) const
{
	for( name_role_map_t::const_iterator rl( m_roles.begin() );
			rl != m_roles.end();
			++rl ) {
		rl->second.show();
	}
}


}  // namespace RUNES
