#ifndef __ROLEMGR_H_INCLUDED
#define __ROLEMGR_H_INCLUDED 1

#include <string>
#include <list>
#include <boost/utility.hpp>

namespace RUNES {


class Role;
class RoleManagerIMPL;


class RoleManager : private boost::noncopyable {
public:
	explicit RoleManager(const std::string& roles_dir);
	~RoleManager();
public:
	void initialize(void);
public:
	const Role* find(const std::string& name) const;
	const std::string& getBaseDir(void) const;
	const std::list<const Role*> getList(void) const;
	void show(void) const;
private:
	RoleManagerIMPL* m_impl;
private:
	RoleManager();
};


}  // namespace RUNES

#endif /* rolemgr.h */
