#include "rolemgr.h"
#include "rolemgr_impl.h"

namespace RUNES {


// コンストラクタ
RoleManager::RoleManager(const std::string& roles_dir)
{
	m_impl = new RoleManagerIMPL(roles_dir);
}


// デストラクタ
RoleManager::~RoleManager()
{
	delete m_impl;
}


// public:
void RoleManager::initialize(void)
{
	return m_impl->initialize();
}

const Role* RoleManager::find(const std::string& name) const
{
	return m_impl->find(name);
}

const std::string& RoleManager::getBaseDir(void) const
{
	return m_impl->getBaseDir();
}

const std::list<const Role*> RoleManager::getList(void) const
{
	return m_impl->getList();
}

void RoleManager::show(void) const
{
	return m_impl->show();
}


}  // namespace RUNES

