#include "role.h"
#include "runestree.h"
#include "filesystem.h"
#include "exception.h"
#include <sys/types.h>
#include <dirent.h>

#include <iostream>

namespace RUNES {


// コンストラクタ
Role::Role(const std::string& path) :
	m_path(path)
{
}


// デストラクタ
Role::~Role()
{
}


// public:
void Role::initialize(void)
{
	DIR *dir_parts;
	dir_parts = ::opendir( m_path.c_str() );
	if( dir_parts == NULL ) {
		// XXX: 例外を作る
		throw std::runtime_error( std::string("Can't open ") + m_path );
	}

	struct dirent* di;
	while( (di = ::readdir(dir_parts)) != NULL ) {
		const std::string dirname(di->d_name);
		if( ! FileSystem::isSuffix(dirname, RolesDir::PARTS_SUFFIX) ) {
			continue;
		}

		m_parts.push_back( FileSystem::removeSuffix(dirname, RolesDir::PARTS_SUFFIX) );
	}

	::closedir(dir_parts);
}

const std::string& Role::getPath(void) const
{
	return m_path;
}

const std::string Role::getName(void) const
{
	return FileSystem::basename(m_path);
}

const std::list<std::string> Role::getParts(void) const
{
	return m_parts;
}

void Role::show(void) const
{
	std::cout << "Role " << m_path << std::endl;
	for( std::list<std::string>::const_iterator pt( m_parts.begin() );
			pt != m_parts.end();
			++pt ) {
		std::cout << "  " << *pt << "\n";
	}
	std::cout << std::endl;
}


}  // namespace RUNES

