#include "net.h"
#include <sys/types.h>
#include <unistd.h>
#include <cstdio>
#include <curl/curl.h>
#include <curl/types.h>
#include <curl/easy.h>

namespace RUNES {


namespace {
int WriteToFile(void *buffer, size_t size, size_t nmemb, void *stream)
{
        if( !stream ) return -1;
	return ::fwrite(buffer, size, nmemb, static_cast<FILE*>(stream));
}
}  // noname namespace

bool downloadFile(const std::string& url, const std::string& path)
{
	::CURL *curl;
	::CURLcode res;
	FILE* stream;

	stream = ::fopen(path.c_str(), "wb");
	if( !stream ) {
		return false;
	}

	curl_global_init(CURL_GLOBAL_DEFAULT);
	curl = curl_easy_init();
	if( !curl ) return false;

	curl_easy_setopt(curl, CURLOPT_URL, url.c_str());
	curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteToFile);
	curl_easy_setopt(curl, CURLOPT_WRITEDATA, stream);
	curl_easy_setopt(curl, CURLOPT_VERBOSE, true);  // XXX: true -> false
	res = curl_easy_perform(curl);
	curl_easy_cleanup(curl);

	if( res != CURLE_OK ) {
		return false;
	}

	::fclose(stream);
	curl_global_cleanup();

	return true;
}


}  // namespace RUNES
