#ifndef __METADB_H_INCLUDED
#define __METADB_H_INCLUDED 1

#include "exception.h"
#include <string>
#include <list>
#include <map>
#include <boost/utility.hpp>

namespace RUNES {

namespace Manager {


class Meta;

class MetaDB : private boost::noncopyable {
public:
	MetaDB(const std::string& db_path, const std::string& db_url);
	~MetaDB();
public:
	void initialize(void);
public:
	const Meta* find(const std::string& name) const;
	const std::list<const Meta*> getList(void) const;
	void show(void) const;
	const std::string& getDBURL(void) const { return m_db_url; }
private:
	std::string m_db_path;
	std::string m_db_url;
	typedef std::map<std::string, Meta> name_meta_map_t;
	name_meta_map_t m_meta_map;
private:
	bool renewMetaDB(const std::string& url, const std::string& path) const;
private:
	MetaDB();
};


RUNES_MakeRuntimeError( MetaDBUpdateError );


}  // namespace Manager

}  // namespace RUNES

#endif /* metadb.h */
