#include "metadb.h"
#include "meta.h"
#include "metadb_parser.h"
#include "runestree.h"
#include "filesystem.h"
#include "net.h"
#include <cstdlib>
#include <fstream>

namespace RUNES {

namespace Manager {


// コンストラクタ
MetaDB::MetaDB(const std::string& db_path, const std::string& db_url) :
	m_db_path(db_path),
	m_db_url(db_url)
{}


// デストラクタ
MetaDB::~MetaDB()
{}


// public:
void MetaDB::initialize(void)
{
	if( ! renewMetaDB(m_db_url, m_db_path) ) {
		throw MetaDBUpdateError(
				std::string("Can't update metadata detabase file " + m_db_path + " from " + m_db_url)
				);
	}

	std::ifstream file(m_db_path.c_str());
	if( ! file.is_open() ) {
		// XXX:
		std::runtime_error( std::string("Can't open ") + m_db_path + "/" + BundleComponent::METADATA_FILE_NAME );
	}
	MetaDBParser parser(file, &m_meta_map);		// XXX: 例外は呼び出し元で
	parser.parse();
	file.close();   // parse()より前にcloseしてはいけない
}

const std::list<const Meta*> MetaDB::getList(void) const
{
	std::list<const Meta*> list;
	for(name_meta_map_t::const_iterator me(m_meta_map.begin()), me_end(m_meta_map.end());
			me != me_end;
			++me ) {
		list.push_back( &(me->second) );
	}
	return list;
}

void MetaDB::show() const
{
	// XXX:
}


namespace {
bool checksum(const std::string& sum_file)
{
	std::string dirname( FileSystem::dirname(sum_file) );
	std::string basename( FileSystem::basename(sum_file) );

	std::string cmd;
	cmd += "cd ";
	cmd += dirname;
	cmd += " && ";
	cmd += "md5sum -c ";
	cmd += basename;
	cmd += " >/dev/null 2>&1";

	int ret = ::system(cmd.c_str());

	return (WEXITSTATUS(ret) == 0);
}
}  // noname namespace


bool MetaDB::renewMetaDB(const std::string& url, const std::string& path) const
{
	if( ! FileSystem::checkFileExists(m_db_path) ) {
		return downloadFile(url, path);
	}

	if( downloadFile(url+".sum", path+".sum") ) {
		if( !checksum(path+".sum") ) {
			return downloadFile(url, path);
		} else {
			return true;
		}
	} else {
		return false;
	}
}


}  // namespace Manager

}  // namespace RUNES

