#include "installer.h"
#include "rune.h"
#include "filesystem.h"
#include "net.h"
#include <iostream>

namespace RUNES {

namespace Manager {


// コンストラクタ
Installer::Installer(const RuneManager& nmgr, const BundleManager& bmgr) :
	m_nmgr(nmgr),
	m_bmgr(bmgr)
{}


// デストラクタ
Installer::~Installer()
{}


namespace {
struct AskMethodFirst {
	const Rune* operator() (std::list<const Rune*>* list)
	{
		std::cout << "ask method first" << std::endl;
		return *list->begin();
	}
};
}  // namespace

// public:
int Installer::command(const std::vector<std::string>& args)
{
	std::string target( *args.begin() );
	const Rune* tr( m_nmgr.find(target) );
	if( tr == NULL ) {
		std::cout << "No such RUNE: " << target << std::endl;
		return 1;
	}

	std::list<const Rune*> lacks;
	AskMethodFirst asf;
	tr->getRecursiveBundleDepend(m_bmgr, m_nmgr, &lacks, asf);

	std::cout << "Following runes will be Installed:" << std::endl;
	for(std::list<const Rune*>::const_iterator inst(lacks.begin()), inst_end(lacks.end());
			inst != inst_end;
			++inst ) {
		std::cout << (*inst)->getSource().getName() << std::endl;
	}

	std::string baseurl( m_nmgr.getBaseURL() );
	baseurl += "/";
	std::string basedir( m_bmgr.getBaseDir() );
	basedir += "/";
	for(std::list<const Rune*>::const_iterator inst(lacks.begin()), inst_end(lacks.end());
			inst != inst_end;
			++inst ) {
		std::cout << "Installing " << (*inst)->getSource().getName() << std::endl;
		std::string down_url( baseurl + (*inst)->getSource().getLocation() );
		std::string inst_file( FileSystem::basename( (*inst)->getSource().getLocation() ) );
		downloadFile(
				down_url,
				basedir + inst_file
			    );
		::system( (
				std::string("cd ") +
				basedir +
				" && (gunzip -c " + inst_file + " | cpio -ivd)"
			  ).c_str() );
	}

	return 1;
}


}  // namespace Manager

}  // namespace RUNES
